using System;
using System.Reflection;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Blood bag label control. Used to display blood bag information as a representation of a blood bag label
		///</summary>

		#endregion


	public class BloodUnitLabel : GUI.controls.BaseControl
	{
		/// <summary>
		/// Local variable for label's blood unit
		/// </summary>
		private BOL.BloodUnit _bloodUnit;
		
		#region Controls

		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Panel pnlCodabar;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblProductCode;
		private System.Windows.Forms.Label lblDonationType;
		private System.Windows.Forms.Label lblProductShortName;
		private System.Windows.Forms.Label lblExpires;
		private System.Windows.Forms.PictureBox picBiohazard;
		private System.Windows.Forms.PictureBox picRhNegative;
		private System.Windows.Forms.PictureBox picABNeg;
		private System.Windows.Forms.PictureBox picABPos;
		private System.Windows.Forms.PictureBox picRhPositive;
		private System.Windows.Forms.PictureBox picONeg;
		private System.Windows.Forms.PictureBox picOPos;
		private System.Windows.Forms.PictureBox picBNeg;
		private System.Windows.Forms.PictureBox picBPos;
		private System.Windows.Forms.PictureBox picANeg;
		private System.Windows.Forms.PictureBox picAPos;
		private System.Windows.Forms.Panel pnlISBT;
		private System.Windows.Forms.Label lblISBTUnitID;
		private System.Windows.Forms.Label lblISBTProductCode;
		private System.Windows.Forms.Label lblISBTProductShortName;
		private System.Windows.Forms.Label lblISBTExpirationDateCode;
		private System.Windows.Forms.Label lblISBTExpirationDate;
		private System.Windows.Forms.Label lblISBTDonationType;
		private System.Windows.Forms.PictureBox picISBTBiohazard;
		private System.Windows.Forms.Label lblISBTABO;
		private System.Windows.Forms.Label lblISBTRh;
		private System.Windows.Forms.Label lblISBTFacilityName;
		private System.Windows.Forms.Label lblFacilityName;
		private System.Windows.Forms.Label lblFDARegNo;
		private System.Windows.Forms.PictureBox picQuarantine;
		private System.Windows.Forms.PictureBox picISBTQuarantine;
		private System.Windows.Forms.PictureBox picRhPooled;
		private System.Windows.Forms.PictureBox picMixed;
		private System.Windows.Forms.PictureBox picISBTMixed;
		private System.ComponentModel.IContainer components;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// BloodUnitLabel control constructor. Creates the instance of the control.
		/// </summary>
		public BloodUnitLabel()
		{
			InitializeComponent();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// BloodUnitLabel control constructor. Creates the instance of the control and
		/// adds it to the existing container.
		/// </summary>
		/// <param name="components"></param>
		public BloodUnitLabel(System.ComponentModel.IContainer components)
		{
			InitializeComponent();
			//
			this.components = components;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(BloodUnitLabel));
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.pnlCodabar = new System.Windows.Forms.Panel();
			this.picMixed = new System.Windows.Forms.PictureBox();
			this.picRhPooled = new System.Windows.Forms.PictureBox();
			this.picQuarantine = new System.Windows.Forms.PictureBox();
			this.lblFDARegNo = new System.Windows.Forms.Label();
			this.lblFacilityName = new System.Windows.Forms.Label();
			this.picBiohazard = new System.Windows.Forms.PictureBox();
			this.picRhNegative = new System.Windows.Forms.PictureBox();
			this.picABNeg = new System.Windows.Forms.PictureBox();
			this.picABPos = new System.Windows.Forms.PictureBox();
			this.picRhPositive = new System.Windows.Forms.PictureBox();
			this.picONeg = new System.Windows.Forms.PictureBox();
			this.picOPos = new System.Windows.Forms.PictureBox();
			this.picBNeg = new System.Windows.Forms.PictureBox();
			this.picBPos = new System.Windows.Forms.PictureBox();
			this.picANeg = new System.Windows.Forms.PictureBox();
			this.picAPos = new System.Windows.Forms.PictureBox();
			this.lblUnitID = new System.Windows.Forms.Label();
			this.lblProductCode = new System.Windows.Forms.Label();
			this.lblDonationType = new System.Windows.Forms.Label();
			this.lblProductShortName = new System.Windows.Forms.Label();
			this.lblExpires = new System.Windows.Forms.Label();
			this.pnlISBT = new System.Windows.Forms.Panel();
			this.picISBTMixed = new System.Windows.Forms.PictureBox();
			this.picISBTQuarantine = new System.Windows.Forms.PictureBox();
			this.lblISBTFacilityName = new System.Windows.Forms.Label();
			this.lblISBTRh = new System.Windows.Forms.Label();
			this.picISBTBiohazard = new System.Windows.Forms.PictureBox();
			this.lblISBTDonationType = new System.Windows.Forms.Label();
			this.lblISBTExpirationDate = new System.Windows.Forms.Label();
			this.lblISBTExpirationDateCode = new System.Windows.Forms.Label();
			this.lblISBTProductShortName = new System.Windows.Forms.Label();
			this.lblISBTProductCode = new System.Windows.Forms.Label();
			this.lblISBTUnitID = new System.Windows.Forms.Label();
			this.lblISBTABO = new System.Windows.Forms.Label();
			this.pnlCodabar.SuspendLayout();
			this.pnlISBT.SuspendLayout();
			this.SuspendLayout();
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// pnlCodabar
			// 
			this.pnlCodabar.BackColor = System.Drawing.Color.GhostWhite;
			this.pnlCodabar.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("pnlCodabar.BackgroundImage")));
			this.pnlCodabar.Controls.Add(this.picMixed);
			this.pnlCodabar.Controls.Add(this.picRhPooled);
			this.pnlCodabar.Controls.Add(this.picQuarantine);
			this.pnlCodabar.Controls.Add(this.lblFDARegNo);
			this.pnlCodabar.Controls.Add(this.lblFacilityName);
			this.pnlCodabar.Controls.Add(this.picBiohazard);
			this.pnlCodabar.Controls.Add(this.picRhNegative);
			this.pnlCodabar.Controls.Add(this.picABNeg);
			this.pnlCodabar.Controls.Add(this.picABPos);
			this.pnlCodabar.Controls.Add(this.picRhPositive);
			this.pnlCodabar.Controls.Add(this.picONeg);
			this.pnlCodabar.Controls.Add(this.picOPos);
			this.pnlCodabar.Controls.Add(this.picBNeg);
			this.pnlCodabar.Controls.Add(this.picBPos);
			this.pnlCodabar.Controls.Add(this.picANeg);
			this.pnlCodabar.Controls.Add(this.picAPos);
			this.pnlCodabar.Controls.Add(this.lblUnitID);
			this.pnlCodabar.Controls.Add(this.lblProductCode);
			this.pnlCodabar.Controls.Add(this.lblDonationType);
			this.pnlCodabar.Controls.Add(this.lblProductShortName);
			this.pnlCodabar.Controls.Add(this.lblExpires);
			this.pnlCodabar.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlCodabar.Location = new System.Drawing.Point(0, 0);
			this.pnlCodabar.Name = "pnlCodabar";
			this.pnlCodabar.Size = new System.Drawing.Size(257, 204);
			this.pnlCodabar.TabIndex = 18;
			// 
			// picMixed
			// 
			this.picMixed.Image = ((System.Drawing.Image)(resources.GetObject("picMixed.Image")));
			this.picMixed.Location = new System.Drawing.Point(164, 56);
			this.picMixed.Name = "picMixed";
			this.picMixed.Size = new System.Drawing.Size(92, 44);
			this.picMixed.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picMixed.TabIndex = 43;
			this.picMixed.TabStop = false;
			this.picMixed.Visible = false;
			// 
			// picRhPooled
			// 
			this.picRhPooled.Image = ((System.Drawing.Image)(resources.GetObject("picRhPooled.Image")));
			this.picRhPooled.Location = new System.Drawing.Point(155, 100);
			this.picRhPooled.Name = "picRhPooled";
			this.picRhPooled.Size = new System.Drawing.Size(101, 21);
			this.picRhPooled.TabIndex = 42;
			this.picRhPooled.TabStop = false;
			this.picRhPooled.Visible = false;
			// 
			// picQuarantine
			// 
			this.picQuarantine.Image = ((System.Drawing.Image)(resources.GetObject("picQuarantine.Image")));
			this.picQuarantine.Location = new System.Drawing.Point(2, 38);
			this.picQuarantine.Name = "picQuarantine";
			this.picQuarantine.Size = new System.Drawing.Size(80, 15);
			this.picQuarantine.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picQuarantine.TabIndex = 41;
			this.picQuarantine.TabStop = false;
			this.picQuarantine.Visible = false;
			// 
			// lblFDARegNo
			// 
			this.lblFDARegNo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblFDARegNo.Location = new System.Drawing.Point(156, 188);
			this.lblFDARegNo.Name = "lblFDARegNo";
			this.lblFDARegNo.Size = new System.Drawing.Size(100, 12);
			this.lblFDARegNo.TabIndex = 40;
			this.lblFDARegNo.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblFacilityName
			// 
			this.lblFacilityName.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblFacilityName.Location = new System.Drawing.Point(156, 128);
			this.lblFacilityName.Name = "lblFacilityName";
			this.lblFacilityName.Size = new System.Drawing.Size(96, 28);
			this.lblFacilityName.TabIndex = 39;
			this.lblFacilityName.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// picBiohazard
			// 
			this.picBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picBiohazard.Image")));
			this.picBiohazard.Location = new System.Drawing.Point(2, 2);
			this.picBiohazard.Name = "picBiohazard";
			this.picBiohazard.Size = new System.Drawing.Size(30, 38);
			this.picBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picBiohazard.TabIndex = 38;
			this.picBiohazard.TabStop = false;
			this.picBiohazard.Visible = false;
			// 
			// picRhNegative
			// 
			this.picRhNegative.Image = ((System.Drawing.Image)(resources.GetObject("picRhNegative.Image")));
			this.picRhNegative.Location = new System.Drawing.Point(155, 100);
			this.picRhNegative.Name = "picRhNegative";
			this.picRhNegative.Size = new System.Drawing.Size(101, 21);
			this.picRhNegative.TabIndex = 37;
			this.picRhNegative.TabStop = false;
			this.picRhNegative.Visible = false;
			// 
			// picABNeg
			// 
			this.picABNeg.Image = ((System.Drawing.Image)(resources.GetObject("picABNeg.Image")));
			this.picABNeg.Location = new System.Drawing.Point(212, 28);
			this.picABNeg.Name = "picABNeg";
			this.picABNeg.Size = new System.Drawing.Size(44, 67);
			this.picABNeg.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picABNeg.TabIndex = 36;
			this.picABNeg.TabStop = false;
			this.picABNeg.Visible = false;
			// 
			// picABPos
			// 
			this.picABPos.Image = ((System.Drawing.Image)(resources.GetObject("picABPos.Image")));
			this.picABPos.Location = new System.Drawing.Point(212, 28);
			this.picABPos.Name = "picABPos";
			this.picABPos.Size = new System.Drawing.Size(44, 67);
			this.picABPos.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picABPos.TabIndex = 35;
			this.picABPos.TabStop = false;
			this.picABPos.Visible = false;
			// 
			// picRhPositive
			// 
			this.picRhPositive.Image = ((System.Drawing.Image)(resources.GetObject("picRhPositive.Image")));
			this.picRhPositive.Location = new System.Drawing.Point(155, 100);
			this.picRhPositive.Name = "picRhPositive";
			this.picRhPositive.Size = new System.Drawing.Size(101, 21);
			this.picRhPositive.TabIndex = 28;
			this.picRhPositive.TabStop = false;
			this.picRhPositive.Visible = false;
			// 
			// picONeg
			// 
			this.picONeg.Image = ((System.Drawing.Image)(resources.GetObject("picONeg.Image")));
			this.picONeg.Location = new System.Drawing.Point(212, 28);
			this.picONeg.Name = "picONeg";
			this.picONeg.Size = new System.Drawing.Size(44, 67);
			this.picONeg.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picONeg.TabIndex = 34;
			this.picONeg.TabStop = false;
			this.picONeg.Visible = false;
			// 
			// picOPos
			// 
			this.picOPos.Image = ((System.Drawing.Image)(resources.GetObject("picOPos.Image")));
			this.picOPos.Location = new System.Drawing.Point(212, 28);
			this.picOPos.Name = "picOPos";
			this.picOPos.Size = new System.Drawing.Size(44, 67);
			this.picOPos.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picOPos.TabIndex = 33;
			this.picOPos.TabStop = false;
			this.picOPos.Visible = false;
			// 
			// picBNeg
			// 
			this.picBNeg.Image = ((System.Drawing.Image)(resources.GetObject("picBNeg.Image")));
			this.picBNeg.Location = new System.Drawing.Point(212, 28);
			this.picBNeg.Name = "picBNeg";
			this.picBNeg.Size = new System.Drawing.Size(44, 67);
			this.picBNeg.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picBNeg.TabIndex = 32;
			this.picBNeg.TabStop = false;
			this.picBNeg.Visible = false;
			// 
			// picBPos
			// 
			this.picBPos.Image = ((System.Drawing.Image)(resources.GetObject("picBPos.Image")));
			this.picBPos.Location = new System.Drawing.Point(212, 28);
			this.picBPos.Name = "picBPos";
			this.picBPos.Size = new System.Drawing.Size(44, 67);
			this.picBPos.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picBPos.TabIndex = 31;
			this.picBPos.TabStop = false;
			this.picBPos.Visible = false;
			// 
			// picANeg
			// 
			this.picANeg.Image = ((System.Drawing.Image)(resources.GetObject("picANeg.Image")));
			this.picANeg.Location = new System.Drawing.Point(212, 28);
			this.picANeg.Name = "picANeg";
			this.picANeg.Size = new System.Drawing.Size(44, 67);
			this.picANeg.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picANeg.TabIndex = 30;
			this.picANeg.TabStop = false;
			this.picANeg.Visible = false;
			// 
			// picAPos
			// 
			this.picAPos.Image = ((System.Drawing.Image)(resources.GetObject("picAPos.Image")));
			this.picAPos.Location = new System.Drawing.Point(212, 28);
			this.picAPos.Name = "picAPos";
			this.picAPos.Size = new System.Drawing.Size(44, 67);
			this.picAPos.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picAPos.TabIndex = 29;
			this.picAPos.TabStop = false;
			this.picAPos.Visible = false;
			// 
			// lblUnitID
			// 
			this.lblUnitID.Font = new System.Drawing.Font("Century Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblUnitID.Location = new System.Drawing.Point(8, 10);
			this.lblUnitID.Name = "lblUnitID";
			this.lblUnitID.Size = new System.Drawing.Size(144, 20);
			this.lblUnitID.TabIndex = 22;
			this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblProductCode
			// 
			this.lblProductCode.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblProductCode.Location = new System.Drawing.Point(92, 112);
			this.lblProductCode.Name = "lblProductCode";
			this.lblProductCode.Size = new System.Drawing.Size(48, 10);
			this.lblProductCode.TabIndex = 21;
			this.lblProductCode.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblDonationType
			// 
			this.lblDonationType.Font = new System.Drawing.Font("Century Gothic", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblDonationType.ForeColor = System.Drawing.Color.Red;
			this.lblDonationType.Location = new System.Drawing.Point(4, 152);
			this.lblDonationType.Name = "lblDonationType";
			this.lblDonationType.Size = new System.Drawing.Size(148, 16);
			this.lblDonationType.TabIndex = 20;
			this.lblDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblProductShortName
			// 
			this.lblProductShortName.Font = new System.Drawing.Font("Century Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblProductShortName.ForeColor = System.Drawing.Color.Red;
			this.lblProductShortName.Location = new System.Drawing.Point(4, 56);
			this.lblProductShortName.Name = "lblProductShortName";
			this.lblProductShortName.Size = new System.Drawing.Size(148, 36);
			this.lblProductShortName.TabIndex = 19;
			// 
			// lblExpires
			// 
			this.lblExpires.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblExpires.Location = new System.Drawing.Point(156, 12);
			this.lblExpires.Name = "lblExpires";
			this.lblExpires.Size = new System.Drawing.Size(100, 10);
			this.lblExpires.TabIndex = 18;
			this.lblExpires.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlISBT
			// 
			this.pnlISBT.BackColor = System.Drawing.Color.GhostWhite;
			this.pnlISBT.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("pnlISBT.BackgroundImage")));
			this.pnlISBT.Controls.Add(this.picISBTMixed);
			this.pnlISBT.Controls.Add(this.picISBTQuarantine);
			this.pnlISBT.Controls.Add(this.lblISBTFacilityName);
			this.pnlISBT.Controls.Add(this.lblISBTRh);
			this.pnlISBT.Controls.Add(this.picISBTBiohazard);
			this.pnlISBT.Controls.Add(this.lblISBTDonationType);
			this.pnlISBT.Controls.Add(this.lblISBTExpirationDate);
			this.pnlISBT.Controls.Add(this.lblISBTExpirationDateCode);
			this.pnlISBT.Controls.Add(this.lblISBTProductShortName);
			this.pnlISBT.Controls.Add(this.lblISBTProductCode);
			this.pnlISBT.Controls.Add(this.lblISBTUnitID);
			this.pnlISBT.Controls.Add(this.lblISBTABO);
			this.pnlISBT.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlISBT.Location = new System.Drawing.Point(0, 0);
			this.pnlISBT.Name = "pnlISBT";
			this.pnlISBT.Size = new System.Drawing.Size(257, 204);
			this.pnlISBT.TabIndex = 19;
			this.pnlISBT.Visible = false;
			// 
			// picISBTMixed
			// 
			this.picISBTMixed.Image = ((System.Drawing.Image)(resources.GetObject("picISBTMixed.Image")));
			this.picISBTMixed.Location = new System.Drawing.Point(152, 52);
			this.picISBTMixed.Name = "picISBTMixed";
			this.picISBTMixed.Size = new System.Drawing.Size(92, 44);
			this.picISBTMixed.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picISBTMixed.TabIndex = 44;
			this.picISBTMixed.TabStop = false;
			this.picISBTMixed.Visible = false;
			// 
			// picISBTQuarantine
			// 
			this.picISBTQuarantine.Image = ((System.Drawing.Image)(resources.GetObject("picISBTQuarantine.Image")));
			this.picISBTQuarantine.Location = new System.Drawing.Point(140, 20);
			this.picISBTQuarantine.Name = "picISBTQuarantine";
			this.picISBTQuarantine.Size = new System.Drawing.Size(80, 15);
			this.picISBTQuarantine.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picISBTQuarantine.TabIndex = 42;
			this.picISBTQuarantine.TabStop = false;
			this.picISBTQuarantine.Visible = false;
			// 
			// lblISBTFacilityName
			// 
			this.lblISBTFacilityName.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTFacilityName.Location = new System.Drawing.Point(4, 56);
			this.lblISBTFacilityName.Name = "lblISBTFacilityName";
			this.lblISBTFacilityName.Size = new System.Drawing.Size(120, 20);
			this.lblISBTFacilityName.TabIndex = 10;
			this.lblISBTFacilityName.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblISBTRh
			// 
			this.lblISBTRh.Font = new System.Drawing.Font("Arial Narrow", 14.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTRh.Location = new System.Drawing.Point(136, 100);
			this.lblISBTRh.Name = "lblISBTRh";
			this.lblISBTRh.Size = new System.Drawing.Size(116, 23);
			this.lblISBTRh.TabIndex = 9;
			this.lblISBTRh.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// picISBTBiohazard
			// 
			this.picISBTBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picISBTBiohazard.Image")));
			this.picISBTBiohazard.Location = new System.Drawing.Point(220, 2);
			this.picISBTBiohazard.Name = "picISBTBiohazard";
			this.picISBTBiohazard.Size = new System.Drawing.Size(32, 34);
			this.picISBTBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picISBTBiohazard.TabIndex = 7;
			this.picISBTBiohazard.TabStop = false;
			this.picISBTBiohazard.Visible = false;
			// 
			// lblISBTDonationType
			// 
			this.lblISBTDonationType.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTDonationType.Location = new System.Drawing.Point(4, 112);
			this.lblISBTDonationType.Name = "lblISBTDonationType";
			this.lblISBTDonationType.Size = new System.Drawing.Size(132, 12);
			this.lblISBTDonationType.TabIndex = 6;
			this.lblISBTDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblISBTExpirationDate
			// 
			this.lblISBTExpirationDate.Font = new System.Drawing.Font("Century Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTExpirationDate.Location = new System.Drawing.Point(132, 168);
			this.lblISBTExpirationDate.Name = "lblISBTExpirationDate";
			this.lblISBTExpirationDate.Size = new System.Drawing.Size(124, 32);
			this.lblISBTExpirationDate.TabIndex = 4;
			// 
			// lblISBTExpirationDateCode
			// 
			this.lblISBTExpirationDateCode.Font = new System.Drawing.Font("Century Gothic", 6.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTExpirationDateCode.Location = new System.Drawing.Point(136, 152);
			this.lblISBTExpirationDateCode.Name = "lblISBTExpirationDateCode";
			this.lblISBTExpirationDateCode.Size = new System.Drawing.Size(80, 8);
			this.lblISBTExpirationDateCode.TabIndex = 3;
			this.lblISBTExpirationDateCode.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// lblISBTProductShortName
			// 
			this.lblISBTProductShortName.Font = new System.Drawing.Font("Century Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTProductShortName.Location = new System.Drawing.Point(4, 168);
			this.lblISBTProductShortName.Name = "lblISBTProductShortName";
			this.lblISBTProductShortName.Size = new System.Drawing.Size(120, 32);
			this.lblISBTProductShortName.TabIndex = 2;
			// 
			// lblISBTProductCode
			// 
			this.lblISBTProductCode.Font = new System.Drawing.Font("Century Gothic", 6.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTProductCode.Location = new System.Drawing.Point(20, 160);
			this.lblISBTProductCode.Name = "lblISBTProductCode";
			this.lblISBTProductCode.Size = new System.Drawing.Size(96, 8);
			this.lblISBTProductCode.TabIndex = 1;
			this.lblISBTProductCode.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
			// 
			// lblISBTUnitID
			// 
			this.lblISBTUnitID.Font = new System.Drawing.Font("Century Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTUnitID.Location = new System.Drawing.Point(20, 30);
			this.lblISBTUnitID.Name = "lblISBTUnitID";
			this.lblISBTUnitID.Size = new System.Drawing.Size(112, 20);
			this.lblISBTUnitID.TabIndex = 0;
			this.lblISBTUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblISBTABO
			// 
			this.lblISBTABO.Font = new System.Drawing.Font("Century Gothic", 48F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblISBTABO.Location = new System.Drawing.Point(140, 36);
			this.lblISBTABO.Name = "lblISBTABO";
			this.lblISBTABO.Size = new System.Drawing.Size(112, 72);
			this.lblISBTABO.TabIndex = 8;
			this.lblISBTABO.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// BloodUnitLabel
			// 
			this.BackColor = System.Drawing.Color.WhiteSmoke;
			this.Controls.Add(this.pnlCodabar);
			this.Controls.Add(this.pnlISBT);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "BloodUnitLabel";
			this.Size = new System.Drawing.Size(257, 204);
			this.pnlCodabar.ResumeLayout(false);
			this.pnlISBT.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets blood bag to display on label
		/// </summary>
		[Browsable(false)]
		public BOL.BloodUnit BloodUnit
		{
			get
			{
				return this._bloodUnit;
			}
			set
			{
				this._bloodUnit = value;
				this.Refresh();
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Public method to clear blood bag label details. Removes the blood unit object
		/// and restores the values of blood unit label controls to initial values.
		/// </summary>
		public void ClearBloodUnitLabel()
		{
			this._bloodUnit = null;
			this.InitializeLabel();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///
		/// <summary>
		/// Private method to set all blood bag label controls to initial values
		/// </summary>
		private void InitializeLabel()
		{
			this.lblDonationType.Text = string.Empty;
			this.lblISBTDonationType.Text = string.Empty;
			//
			this.lblUnitID.Text = string.Empty;
			this.lblISBTUnitID.Text = string.Empty;
			//
			this.picBiohazard.Visible = false;
			this.picISBTBiohazard.Visible = false;
			//
			this.SetAboRHImage(Common.ABO.NA,Common.RH.NotProvided,Common.BarcodeType.None);
			//
			this.lblExpires.Text = string.Empty;
			this.lblISBTExpirationDateCode.Text = string.Empty;
			this.lblISBTExpirationDate.Text = string.Empty;
			//
			this.lblProductCode.Text = string.Empty;
			this.lblProductShortName.Text = string.Empty;
			this.toolTip1.SetToolTip(this.lblProductShortName,string.Empty);
			this.lblISBTProductCode.Text = string.Empty;
			this.lblISBTProductShortName.Text = string.Empty;
			this.toolTip1.SetToolTip(this.lblISBTProductShortName,string.Empty);
			//
			this.lblFacilityName.Text = string.Empty;
			this.lblISBTFacilityName.Text = string.Empty;
			this.lblFDARegNo.Text = string.Empty;
			//
			this.picQuarantine.Visible = false;
			this.picISBTQuarantine.Visible = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///
		/// <summary>
		/// Public method to refresh the display of the blood bag label.
		/// Use after updating a property in blood bag.
		/// </summary>
		public override void Refresh()
		{
			this.OnUserActivity();

			if (this._bloodUnit != null)
			{
				this.pnlCodabar.Visible = (this._bloodUnit.BarcodeType == Common.BarcodeType.Codabar);
				this.pnlISBT.Visible = (this._bloodUnit.BarcodeType == Common.BarcodeType.ISBT128);
				
				//
				if(this._bloodUnit.DonationType.DonationTypeCode != 'U' && this._bloodUnit.DonationType.DonationTypeCode != 'O')
				{
					if ((this._bloodUnit.DonationType != null) && (this._bloodUnit.DonationType.DonationTypeText != null))
					{
						if(this._bloodUnit.DonationType.DonationTypeText != string.Empty)
						{
							this.lblDonationType.Text = this.GetDonorCode(this._bloodUnit.DonationType.DonationTypeText);
							this.lblISBTDonationType.Text = this.GetDonorCode(this._bloodUnit.DonationType.DonationTypeText);
						}
						
					}
					else
					{
						this.lblDonationType.Text = string.Empty;
						this.lblISBTDonationType.Text = string.Empty;
					}
				}
				else
				{
					this.lblDonationType.Text = string.Empty;
					this.lblISBTDonationType.Text = string.Empty;
				}
				//
				if (this._bloodUnit.EyeReadableUnitId != null && this._bloodUnit.EyeReadableUnitId.Trim().Length > 0)
					
				{
					this.lblUnitID.Text = this._bloodUnit.EyeReadableUnitId;
				}
				else
				{
					this.lblUnitID.Text = this._bloodUnit.LabelUnitId;
				}
				this.lblISBTUnitID.Text = this._bloodUnit.LabelUnitId;
				//
				this.picBiohazard.Visible = this._bloodUnit.BloodUnitStatus.BiohazardousWarningIndicator;
				this.picISBTBiohazard.Visible = this._bloodUnit.BloodUnitStatus.BiohazardousWarningIndicator;
				//
				this.SetAboRHImage(this._bloodUnit.BloodUnitMedia.AboRh.Abo,this._bloodUnit.BloodUnitMedia.AboRh.RH,this._bloodUnit.BarcodeType);
				//
				if (this._bloodUnit.BloodUnitMedia.UnitExpirationDate>DateTime.MinValue)
				{
					this.lblExpires.Text = this._bloodUnit.BloodUnitMedia.UnitExpirationDate.ToString("MM/dd/yy hh:mmtt");
					this.lblISBTExpirationDate.Text = this._bloodUnit.BloodUnitMedia.UnitExpirationDate.ToString("dd MMM yyyy HH:mm");
					this.lblISBTExpirationDateCode.Text = this.GetISBTDateCode(this._bloodUnit.BloodUnitMedia.UnitExpirationDate);
				}
				else
				{
					this.lblExpires.Text = string.Empty;
					this.lblISBTExpirationDateCode.Text = string.Empty;
					this.lblISBTExpirationDate.Text = string.Empty;
				}
				//
				this.lblProductCode.Text = this._bloodUnit.ProductCode;
				this.lblISBTProductCode.Text = this._bloodUnit.FullProductCode;
				//
				this.lblProductShortName.Text = this.CheckForAmpersands(this._bloodUnit.ProductShortName);
				this.lblISBTProductShortName.Text = this.CheckForAmpersands(this._bloodUnit.ProductShortName);
				//
				this.toolTip1.SetToolTip(this.lblProductShortName, this.CheckForAmpersands(this._bloodUnit.ProductName));
				this.toolTip1.SetToolTip(this.lblISBTProductShortName, this.CheckForAmpersands(this._bloodUnit.ProductName));
				//
				if ((this._bloodUnit.LocalSupplier != null) && (this._bloodUnit.LocalSupplier.FacilityName != null))
				{
					this.lblFacilityName.Text = this.CheckForAmpersands(this._bloodUnit.LocalSupplier.FacilityName);
					this.lblISBTFacilityName.Text = this.CheckForAmpersands(this._bloodUnit.LocalSupplier.FacilityName);
				}
				else
				{
					this.lblFacilityName.Text = string.Empty;
					this.lblISBTFacilityName.Text = string.Empty;
				}
				//
				this.lblFDARegNo.Text = this._bloodUnit.UnitFdaRegistrationNumber;
				//
				if (this._bloodUnit.BloodUnitStatus != null)
				{
					this.picQuarantine.Visible = this._bloodUnit.BloodUnitStatus.QuarantineIndicator;
					this.picISBTQuarantine.Visible = this._bloodUnit.BloodUnitStatus.QuarantineIndicator;
				}
			}
			else
			{
				this.InitializeLabel();
			}
			base.Refresh();
		}

		/// <summary>
		/// One ampersand will cause the character to be underlined, and no ampersand shown
		/// </summary>
		/// <param name="input"></param>
		/// <returns></returns>
		private string CheckForAmpersands(string input)
		{
			return(input.Replace("&","&&"));
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return donor code for label based on donation type
		/// </summary>
		/// <param name="donationTypeText">Donation type</param>
		/// <returns>Donation text for use on label</returns>
		private string GetDonorCode(string donationTypeText)
		{
			//DR 338
//			if (donationTypeText.ToString().ToUpper().IndexOf("AUTOLOGOUS")>-1)
//			{
//				return "AUTOLOGOUS DONOR";
//			}
			if (donationTypeText.ToString().ToUpper().IndexOf("PAID")>-1)
			{
				return "PAID DONOR";
			}
//			else if (donationTypeText.ToString().ToUpper().IndexOf("DIRECTED")>-1)
//			{
//				return "DIRECTED DONOR";
//			}
			else
			{
				return "VOLUNTEER DONOR";
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///
		/// <summary>
		/// Public method to display ABO/Rh ad image or text based on blood type
		/// and barcode type
		/// </summary>
		/// <param name="abo">Blood Type</param>
		/// <param name="rh">Rh Factor</param>
		/// <param name="barcodeType">Barcode Type (Codabar/ISBT-128)</param>
		public void SetAboRHImage(Common.ABO abo, Common.RH rh, Common.BarcodeType barcodeType)
		{
			if (barcodeType == Common.BarcodeType.Codabar)
			{
				this.pnlCodabar.Visible = true;
				
				this.picRhNegative.Visible = (rh == Common.RH.Negative);
				this.picRhPositive.Visible = (rh == Common.RH.Positive);
				this.picRhPooled.Visible = (rh == Common.RH.PooledRH);
				//
				if (rh == Common.RH.Negative)
				{
					this.picANeg.Visible = (abo == Common.ABO.A);
					this.picABNeg.Visible = (abo == Common.ABO.AB);
					this.picBNeg.Visible = (abo == Common.ABO.B);
					this.picONeg.Visible = (abo == Common.ABO.O);
					this.picAPos.Visible = false;
					this.picABPos.Visible = false;
					this.picBPos.Visible = false;
					this.picOPos.Visible = false;
				}
				else
				{
					this.picAPos.Visible = (abo == Common.ABO.A);
					this.picABPos.Visible = (abo == Common.ABO.AB);
					this.picBPos.Visible = (abo == Common.ABO.B);
					this.picOPos.Visible = (abo == Common.ABO.O);
					this.picANeg.Visible = false;
					this.picABNeg.Visible = false;
					this.picBNeg.Visible = false;
					this.picONeg.Visible = false;
				}
				this.picMixed.Visible = (abo == Common.ABO.Mx);
			}
			else if (barcodeType == Common.BarcodeType.ISBT128)
			{
				this.pnlISBT.Visible = true;
				if ((rh == Common.RH.Negative) || (rh == Common.RH.Positive))
				{
					this.lblISBTRh.Text = "Rh "+rh.ToString().ToUpper();
				}
				else if (rh == Common.RH.PooledRH)
				{
					this.lblISBTRh.Text = "POOLED Rh";
				}
				else
				{
					this.lblISBTRh.Text = string.Empty;
				}
				switch (abo)
				{
					case Common.ABO.AB:
					case Common.ABO.B:
					case Common.ABO.A:
					case Common.ABO.O:
						this.lblISBTABO.Text = abo.ToString();
						this.picISBTMixed.Visible = false;
						break;
					case Common.ABO.Mx:
						this.lblISBTABO.Text = "";
						this.picISBTMixed.Visible = true;
						break;
					default:
						this.lblISBTABO.Text = "";
						this.picISBTMixed.Visible = false;
						break;
				}
			}
			else
			{
				this.picRhNegative.Visible = false;
				this.picRhPositive.Visible = false;
				this.picRhPooled.Visible = false;
				this.picANeg.Visible = false;
				this.picABNeg.Visible = false;
				this.picBNeg.Visible = false;
				this.picONeg.Visible = false;
				this.picAPos.Visible = false;
				this.picABPos.Visible = false;
				this.picBPos.Visible = false;
				this.picOPos.Visible = false;
				this.picMixed.Visible = false;
				this.picISBTMixed.Visible = false;
				this.lblISBTABO.Text = string.Empty;
				this.lblISBTRh.Text = string.Empty;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return expiration date as string for ISBT-128 label display
		/// </summary>
		/// <param name="expirationDate">Expiration Date</param>
		/// <returns>Expiration date as cyyjjjhhmm</returns>
		private string GetISBTDateCode(DateTime expirationDate)
		{
			string year = expirationDate.Year.ToString().Substring(1,3);
			System.Globalization.    anCalendar julian = new System.Globalization.    anCalendar();
			//Have to add 13 days to julian date.... why?!?!?!
			string days = "000"+julian.GetDayOfYear(expirationDate.Date.AddDays(13)).ToString();
			days = days.Substring(days.Length-3,3);
			return year+days+expirationDate.ToString("HHmm");
		}

		#endregion


	}
}